#include "General.h"

void AzazelBot_LogBeacon::Created(GameObject *obj)
{
	IsDisarmed = false;
	char tmp[8];

	InvisObjCont = Commands->Get_ID(Commands->Create_Object("Invisible_Object",Commands->Get_Position(obj)));
	sprintf(tmp, "%d", Commands->Get_ID(obj));
	Commands->Attach_Script(Commands->Find_Object(InvisObjCont), "AzazelBot_BeaconCtrl", tmp);
}

void AzazelBot_LogBeacon::Killed(GameObject *obj, GameObject *killer)
{
	if (IsDisarmed == false)
	{
		IsDisarmed = true;
		const char *BeaconName = Functions::Get_Translated_Name(obj);

		IRC::SendC('b', "%s[Beacon]%s %s%S disarmed %S's %s.", GREEN, NM, LGREY, Get_Wide_Player_Name(killer), 
			Get_Wide_Player_Name(Get_Beacon_Planter(obj)), BeaconName);
		
		delete []BeaconName;
	}
}

void AzazelBot_LogBeacon::Destroyed(GameObject *o)
{
	if (InvisObjCont != 0)
	{
		GameObject *Temp = Commands->Find_Object(InvisObjCont);
		if (Temp)
		{
			Commands->Destroy_Object(Temp);
		}
	}
}

void AzazelBot_BeaconCtrl::Created(GameObject *obj)
{
	Commands->Start_Timer(obj, this, (float)5, BEACON_TIMER_DEPLOYED);
	Commands->Start_Timer(obj, this, (float)54, BEACON_TIMER_DETONATED);	
}

void AzazelBot_BeaconCtrl::Timer_Expired(GameObject *obj, int number)
{
	if (number == BEACON_TIMER_DEPLOYED)
	{
		GameObject *Beacon = Commands->Find_Object(atoi(Get_Parameter(0)));
		const char *BeaconName = Functions::Get_Translated_Name(Beacon);

		IRC::SendC(CHAN_PUBLIC, "%s[Beacon]%s %s%S deployed a(n) %s.", GREEN, NM, LGREY,
			Get_Wide_Player_Name(Get_Beacon_Planter(Beacon)), BeaconName);

		delete []BeaconName;
	}
	else if (number == BEACON_TIMER_DETONATED)
	{
		GameObject *Beacon = Commands->Find_Object(atoi(Get_Parameter(0)));

		if (Commands->Is_A_Star(Get_Beacon_Planter(Beacon)))
		{
			const char *BeaconName = Functions::Get_Translated_Name(Beacon);

			IRC::SendC(CHAN_PUBLIC, "%s[Beacon]%s %s%S's %s has detonated.", GREEN, NM, LGREY, Get_Wide_Player_Name(Get_Beacon_Planter(Beacon)), BeaconName);
			
			delete []BeaconName;
		}
	}
}

void AzazelBot_LogVehicle::Killed(GameObject *obj, GameObject *killer)
{
	const char *ObjName = Functions::Get_Translated_Name(obj);

	if (killer)
	{
		const char* KillWeapon = Get_Current_Translated_Weapon(killer);
		
		if (Commands->Is_A_Star(killer))
		{	
			if (!Get_Vehicle_Driver(obj))
			{
				IRC::SendC(CHAN_PUBLIC, "%s%S (%s) destroyed a %s%s\n", Get_Team(Get_Player_ID(killer)) ? YELLOW : RED, Get_Wide_Player_Name(killer), KillWeapon, ObjName, NM);
			}
			else
			{			
				const char *PlayerName = Get_Player_Name(Get_Vehicle_Driver(obj));
				IRC::SendC('b', "%s%S (%s) destroyed %s's %s%s\n", Get_Team(Get_Player_ID(killer)) ? YELLOW : RED, Get_Wide_Player_Name(killer), KillWeapon, PlayerName, ObjName, NM);
 				
				delete []PlayerName;		
			}
		}
		else if (Is_Vehicle(killer))
		{
			const char *KillerPreset = Get_Translated_Preset_Name(killer);
			IRC::SendC('b', "%sThe %s destroyed a %s\n", Get_Team(Get_Player_ID(killer)) ? YELLOW : RED, KillerPreset, ObjName);

			delete []KillerPreset;
		}
		delete []KillWeapon;
	}
	else
	{
		IRC::SendC('b', "%sA %s was destroyed\n", Get_Team(Get_Player_ID(obj)) ? YELLOW : RED, ObjName);
	}
	delete []ObjName;
}

void AzazelBot_LogBuilding::Killed(GameObject *obj, GameObject *killer)
{
	if (killer && Commands->Is_A_Star(killer))
	{
		const char *ObjName = Functions::Get_Translated_Name(obj);
		IRC::SendC(CHAN_PUBLIC, "%s%S Destroyed the %s\n", Get_Team(Get_Player_ID(killer)) ? YELLOW : RED, Get_Wide_Player_Name(killer), ObjName);
	
		delete []ObjName;
	}
}

void AzazelBot_LogPlayer::Killed(GameObject *obj, GameObject *killer)
{
	const char* VictimWeapon = Get_Current_Translated_Weapon(obj);

	if (obj && killer)
	{
		if (Commands->Is_A_Star(killer) && obj != killer)
		{
		    const char* KillWeapon = Get_Current_Translated_Weapon(killer);

			IRC::SendC(CHAN_PUBLIC, "%s%S (%s) killed %S (%s)%s\n", Get_Team(Get_Player_ID(killer)) ? YELLOW : RED, Get_Wide_Player_Name(killer), KillWeapon, Get_Wide_Player_Name(obj), VictimWeapon, NM);

			delete []KillWeapon;
		}
		else if (obj == killer)
		{
				IRC::SendC(CHAN_PUBLIC, "%s%S (%s) committed suicide.\n", Get_Team(Get_Player_ID(obj)) ? YELLOW : RED, Get_Wide_Player_Name(obj), VictimWeapon);
		}
		else if (Is_Vehicle(killer))
		{
			const char *VehicleName = Functions::Get_Translated_Name(killer);
			IRC::SendC(CHAN_PUBLIC, "%s%S (%s) was killed by the %s.\n", Get_Team(Get_Player_ID(obj)) ? YELLOW : RED, Get_Wide_Player_Name(obj), VictimWeapon, VehicleName);
			
			delete []VehicleName;
		}		
	}
	else
	{
		IRC::SendC(CHAN_PUBLIC, "%s%S (%s) has died.\n", Get_Team(Get_Player_ID(obj)) ? YELLOW : RED, Get_Wide_Player_Name(obj), VictimWeapon);
	}
	delete []VictimWeapon;
}

ScriptRegistrant<AzazelBot_LogBeacon> AzazelBot_LogBeacon_Registrant("AzazelBot_LogBeacon", "");
ScriptRegistrant<AzazelBot_BeaconCtrl> AzazelBot_BeaconCtrl_Registrant("AzazelBot_BeaconCtrl", "ID:int");

ScriptRegistrant<AzazelBot_LogVehicle> AzazelBot_LogVehicle_Registrant("AzazelBot_LogVehicle", "");

ScriptRegistrant<AzazelBot_LogBuilding> AzazelBot_LogBuilding_Registrant("AzazelBot_LogBuilding", "");

ScriptRegistrant<AzazelBot_LogPlayer> AzazelBot_LogPlayer_Registrant("AzazelBot_LogPlayer", "");
